/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared.descriptor.sql;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;

public class DstSafeTimeTypeDescriptor
extends TimeTypeDescriptor {
    private static final long serialVersionUID = -1927559005967709998L;
    private final Calendar cal;

    public DstSafeTimeTypeDescriptor() {
        this.cal = null;
    }

    public DstSafeTimeTypeDescriptor(Calendar cal) {
        this.cal = cal;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (DstSafeTimeTypeDescriptor.this.cal == null) {
                    st.setTime(index, javaTypeDescriptor.unwrap(value, Time.class, options));
                } else {
                    st.setTime(index, javaTypeDescriptor.unwrap(value, Time.class, options), DstSafeTimeTypeDescriptor.this.cal);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (DstSafeTimeTypeDescriptor.this.cal == null) {
                    st.setTime(name, javaTypeDescriptor.unwrap(value, Time.class, options));
                } else {
                    st.setTime(name, javaTypeDescriptor.unwrap(value, Time.class, options), DstSafeTimeTypeDescriptor.this.cal);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                if (DstSafeTimeTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(rs.getTime(name), options);
                }
                return javaTypeDescriptor.wrap(rs.getTime(name, DstSafeTimeTypeDescriptor.this.cal), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (DstSafeTimeTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(statement.getTime(index), options);
                }
                return javaTypeDescriptor.wrap(statement.getTime(index, DstSafeTimeTypeDescriptor.this.cal), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (DstSafeTimeTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(statement.getTime(name), options);
                }
                return javaTypeDescriptor.wrap(statement.getTime(name, DstSafeTimeTypeDescriptor.this.cal), options);
            }
        };
    }
}

