/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.SerializationException;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;

public abstract class AbstractUserType
implements Serializable {
    private static final long serialVersionUID = -3503387360213242237L;

    public boolean isMutable() {
        return false;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x == y) {
            return true;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        assert (x != null);
        return x.hashCode();
    }

    public Object assemble(Serializable cachedValue, Object owner) throws HibernateException {
        return this.deepCopy(cachedValue);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        Serializable result;
        if (value == null) {
            result = null;
        } else {
            Object deepCopy = this.deepCopy(value);
            if (!(deepCopy instanceof Serializable)) {
                throw new SerializationException(String.format("deepCopy of %s is not serializable", value), null);
            }
            result = (Serializable)deepCopy;
        }
        return result;
    }

    public Object replace(Object originalValue, Object target, Object owner) throws HibernateException {
        return this.deepCopy(originalValue);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public void beforeNullSafeOperation(SharedSessionContractImplementor session) {
        ConfigurationHelper.setCurrentSessionFactory(session.getFactory());
        if (this instanceof IntegratorConfiguredType) {
            ((IntegratorConfiguredType)((Object)this)).applyConfiguration(session.getFactory());
        }
    }

    public void afterNullSafeOperation(SharedSessionContractImplementor session) {
        ConfigurationHelper.setCurrentSessionFactory(null);
    }
}

