/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.jadira.usertype.spi.shared.AbstractUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ColumnMapperSingleColumnTypeAdapter;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.jadira.usertype.spi.utils.reflection.TypeHelper;

public abstract class AbstractMultiColumnUserType<T>
extends AbstractUserType
implements CompositeUserType,
Serializable {
    private static final long serialVersionUID = -8258683760413283329L;
    private int[] sqlTypes;
    private Type[] hibernateTypes;
    private String[] defaultPropertyNames;

    public AbstractMultiColumnUserType() {
        this.initialise();
    }

    protected final void initialise() {
        this.initialiseSqlTypes();
        this.initialiseHibernateTypes();
        this.initialiseDefaultPropertyNames();
    }

    private void initialiseDefaultPropertyNames() {
        HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
        this.defaultPropertyNames = new String[this.getColumnMappers().length];
        for (int i = 0; i < this.defaultPropertyNames.length; ++i) {
            Integer count;
            String name;
            String className = this.hibernateTypes[i].getClass().getSimpleName();
            if (className.endsWith("Type")) {
                className = className.substring(0, className.length() - 4);
            }
            if (nameCount.containsKey(name = className.toLowerCase())) {
                Integer oldCount = (Integer)nameCount.get(name);
                count = oldCount + 1;
                this.defaultPropertyNames[i] = name + count;
            } else {
                count = 1;
                this.defaultPropertyNames[i] = name;
            }
            nameCount.put(name, count);
        }
    }

    private void initialiseHibernateTypes() {
        this.hibernateTypes = new Type[this.getColumnMappers().length];
        for (int i = 0; i < this.hibernateTypes.length; ++i) {
            this.hibernateTypes[i] = new ColumnMapperSingleColumnTypeAdapter(this.getColumnMappers()[i]);
        }
    }

    private void initialiseSqlTypes() {
        this.sqlTypes = new int[this.getColumnMappers().length];
        for (int i = 0; i < this.sqlTypes.length; ++i) {
            this.sqlTypes[i] = this.getColumnMappers()[i].getSqlType();
        }
    }

    public int[] sqlTypes() {
        return ArrayUtils.copyOf(this.sqlTypes);
    }

    @Override
    public Class<T> returnedClass() {
        return TypeHelper.getTypeArguments(AbstractMultiColumnUserType.class, this.getClass()).get(0);
    }

    protected abstract ColumnMapper<?, ?>[] getColumnMappers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T nullSafeGet(ResultSet resultSet, String[] strings, SharedSessionContractImplementor session, Object object) throws SQLException {
        this.beforeNullSafeOperation(session);
        try {
            Object[] convertedColumns = new Object[this.getColumnMappers().length];
            for (int getIndex = 0; getIndex < this.getColumnMappers().length; ++getIndex) {
                ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[getIndex];
                Object converted = nextMapper.getHibernateType().nullSafeGet(resultSet, strings[getIndex], session, object);
                if (converted == null) continue;
                convertedColumns[getIndex] = nextMapper.fromNonNullValue(converted);
            }
            for (int i = 0; i < convertedColumns.length; ++i) {
                if (convertedColumns[i] == null) continue;
                T t = this.fromConvertedColumns(convertedColumns);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    protected abstract T fromConvertedColumns(Object[] var1);

    protected abstract Object[] toConvertedColumns(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.beforeNullSafeOperation(session);
        try {
            Object[] valuesToSet = new Object[this.getColumnMappers().length];
            if (value != null) {
                Object myValue = value;
                Object[] convertedColumns = this.toConvertedColumns(myValue);
                for (int cIdx = 0; cIdx < valuesToSet.length; ++cIdx) {
                    ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[cIdx];
                    valuesToSet[cIdx] = nextMapper.toNonNullValue(convertedColumns[cIdx]);
                }
            }
            for (int setIndex = 0; setIndex < valuesToSet.length; ++setIndex) {
                ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[setIndex];
                nextMapper.getHibernateType().nullSafeSet(preparedStatement, valuesToSet[setIndex], index + setIndex, session);
            }
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    @Override
    public String[] getPropertyNames() {
        return this.defaultPropertyNames;
    }

    @Override
    public Type[] getPropertyTypes() {
        return ArrayUtils.copyOf(this.hibernateTypes);
    }

    @Override
    public Object getPropertyValue(Object component, int property) throws HibernateException {
        if (!this.returnedClass().isAssignableFrom(component.getClass())) {
            throw new HibernateException("getPropertyValue called with incorrect class: {" + component.getClass() + "}");
        }
        Object[] cols = this.toConvertedColumns(component);
        return cols[property];
    }

    @Override
    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new HibernateException("Called setPropertyValue on an immutable type {" + component.getClass() + "}");
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session) throws HibernateException {
        return super.disassemble(value);
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return super.assemble(cached, owner);
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return super.replace(original, target, owner);
    }
}

