/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.jta;

import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;
import org.springframework.transaction.jta.JtaTransactionManager;

public class HibernateSessionFactoryBean
extends LocalSessionFactoryBean {
    private JtaTransactionManager transactionManager;
    private static final ThreadLocal<JtaTransactionManager> configurationTransactionManagerHolder = new ThreadLocal();

    static JtaTransactionManager getConfigurationTransactionManager() {
        return configurationTransactionManagerHolder.get();
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        if (this.transactionManager != null) {
            configurationTransactionManagerHolder.set(this.transactionManager);
        }
        try {
            SessionFactory sessionFactory = super.buildSessionFactory(sfb);
            return sessionFactory;
        }
        finally {
            if (this.transactionManager != null) {
                configurationTransactionManagerHolder.set(null);
            }
        }
    }

    public void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

