/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.moneta.columnmapper;

import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import org.jadira.usertype.moneyandcurrency.moneta.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.function.MonetaryUtil;

public class LongColumnFastMoneyMajorMapper
extends AbstractLongColumnMapper<MonetaryAmount>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    @Override
    public FastMoney fromNonNullValue(Long val) {
        return FastMoney.of((Number)val, (CurrencyUnit)this.currencyUnit);
    }

    @Override
    public Long toNonNullValue(MonetaryAmount value) {
        if (!this.currencyUnit.equals(value.getCurrency())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrency());
        }
        return MonetaryUtil.majorPart().apply(value).getNumber().longValue();
    }

    @Override
    public FastMoney fromNonNullString(String s) {
        int separator = s.indexOf(32);
        String currency = s.substring(0, separator);
        String value = s.substring(separator + 1);
        return FastMoney.of((Number)Long.parseLong(value), (CurrencyUnit)Monetary.getCurrency((String)currency, (String[])new String[0]));
    }

    @Override
    public String toNonNullString(MonetaryAmount value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

