/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.moneta;

import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.jadira.usertype.moneyandcurrency.legacyjdk.columnmapper.LongLongColumnMapper;
import org.jadira.usertype.moneyandcurrency.moneta.columnmapper.StringColumnCurrencyUnitMapper;
import org.jadira.usertype.spi.shared.AbstractMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.function.MonetaryUtil;

public class PersistentMoneyMajorAmountAndCurrency
extends AbstractMultiColumnUserType<MonetaryAmount> {
    private static final long serialVersionUID = -3990523657883978202L;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new StringColumnCurrencyUnitMapper(), new LongLongColumnMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"currencyUnit", "amountMajor"};

    @Override
    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    @Override
    protected Money fromConvertedColumns(Object[] convertedColumns) {
        CurrencyUnit currencyUnitPart = (CurrencyUnit)convertedColumns[0];
        Long amountMajorPart = (Long)convertedColumns[1];
        Money money = Money.of((Number)amountMajorPart, (CurrencyUnit)currencyUnitPart);
        return money;
    }

    @Override
    protected Object[] toConvertedColumns(MonetaryAmount value) {
        return new Object[]{value.getCurrency(), MonetaryUtil.majorPart().apply(value).getNumber().longValue()};
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

