/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.joda.columnmapper;

import java.math.BigDecimal;
import org.jadira.usertype.moneyandcurrency.joda.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractBigDecimalColumnMapper;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.CurrencyUnit;

public class BigDecimalColumnBigMoneyMapper
extends AbstractBigDecimalColumnMapper<BigMoney>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    @Override
    public BigMoney fromNonNullValue(BigDecimal val) {
        return BigMoney.of((CurrencyUnit)this.currencyUnit, (BigDecimal)val);
    }

    @Override
    public BigDecimal toNonNullValue(BigMoney value) {
        if (!this.currencyUnit.equals((Object)value.getCurrencyUnit())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrencyUnit());
        }
        return BigMoney.of((BigMoneyProvider)value).getAmount();
    }

    @Override
    public BigMoney fromNonNullString(String s) {
        return BigMoney.parse((String)s);
    }

    @Override
    public String toNonNullString(BigMoney value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

