/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.json.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.spi.shared.AbstractKnownClassHeuristicUserType;

public class PersistentJsonObjectAsString<T>
extends AbstractKnownClassHeuristicUserType<T>
implements ParameterizedType {
    private static final long serialVersionUID = 3094384329334123541L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ObjectReader objectReader;
    private ObjectWriter objectWriter;

    protected ObjectReader getObjectReader() {
        return this.objectReader;
    }

    protected ObjectWriter getObjectWriter() {
        return this.objectWriter;
    }

    @Override
    protected void setMappedClass(Class<T> mappedClass) {
        super.setMappedClass(mappedClass);
        this.objectReader = OBJECT_MAPPER.readerFor(mappedClass);
        this.objectWriter = OBJECT_MAPPER.writerFor(mappedClass);
    }

    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters.containsKey("jsonClass")) {
            String jsonClassName = parameters.getProperty("jsonClass");
            try {
                this.setMappedClass(Class.forName(jsonClassName));
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Specified class could not be found", e);
            }
        }
        super.setParameterValues(parameters);
    }

    @Override
    public Class<T> returnedClass() {
        Class mappedClass = this.getMappedClass();
        if (mappedClass == null) {
            throw new IllegalStateException("class was not defined for " + this.getClass().getName());
        }
        return mappedClass;
    }

    @Override
    public Object doNullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object obj;
        String jsonText = (String)this.getType().get(rs, names[0], session);
        if (rs.wasNull()) {
            return null;
        }
        try {
            obj = this.getObjectReader().readValue(jsonText);
        }
        catch (JsonParseException e) {
            throw new HibernateException("Problem parsing retrieved JSON String: " + jsonText, e);
        }
        catch (JsonMappingException e) {
            throw new HibernateException("Problem mapping retrieved JSON String: " + jsonText, e);
        }
        catch (IOException e) {
            throw new HibernateException("Problem reading JSON String: " + jsonText, e);
        }
        return obj;
    }

    @Override
    public void doNullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            preparedStatement.setNull(index, this.getType().sqlType());
        } else {
            try {
                String identifier = this.objectWriter.writeValueAsString(value);
                this.getType().nullSafeSet(preparedStatement, (Object)identifier, index, session);
            }
            catch (JsonProcessingException e) {
                throw new HibernateException("Problem writing JSON String: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String objectToSQLString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException("Cannot serialize JSON object: " + e.getMessage(), e);
        }
    }

    @Override
    public String toXMLString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException("Cannot serialize JSON object: " + e.getMessage(), e);
        }
    }
}

