/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.json.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jadira.usertype.json.jackson.PersistentJsonObjectAsString;
import org.postgresql.util.PGobject;

public class PersistentJsonObjectAsPostgreSQLJson<T>
extends PersistentJsonObjectAsString<T> {
    private static final long serialVersionUID = 228945479215593795L;
    private static boolean HAS_POSTGRES_DRIVER;

    @Override
    public Object doNullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String jsonText;
        Object identifier = rs.getObject(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        if (HAS_POSTGRES_DRIVER && identifier instanceof PGobject) {
            PGobject pg = (PGobject)identifier;
            jsonText = pg.getValue();
        } else if (identifier instanceof String) {
            jsonText = (String)identifier;
        } else {
            throw new IllegalArgumentException("PersistentJsonObjectAsPostgreSQLJson type expected PGobject, received " + identifier.getClass().getName() + " with value of '" + identifier + "'");
        }
        try {
            Object obj = this.getObjectReader().readValue(jsonText);
            return obj;
        }
        catch (JsonParseException e) {
            throw new HibernateException("Problem parsing retrieved JSON String: " + jsonText, e);
        }
        catch (JsonMappingException e) {
            throw new HibernateException("Problem mapping retrieved JSON String: " + jsonText, e);
        }
        catch (IOException e) {
            throw new HibernateException("Problem reading JSON String: " + jsonText, e);
        }
    }

    @Override
    public void doNullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            preparedStatement.setNull(index, 0);
        } else {
            try {
                String jsonObject;
                String identifier = this.getObjectWriter().writeValueAsString(value);
                if (HAS_POSTGRES_DRIVER) {
                    PGobject pgObject = new PGobject();
                    pgObject.setType("json");
                    pgObject.setValue(identifier);
                    jsonObject = pgObject;
                } else {
                    jsonObject = identifier;
                }
                preparedStatement.setObject(index, jsonObject);
            }
            catch (JsonProcessingException e) {
                throw new HibernateException("Problem writing JSON String: " + e.getMessage(), e);
            }
        }
    }

    static {
        try {
            Class.forName("org.postgresql.util.PGobject");
            HAS_POSTGRES_DRIVER = true;
        }
        catch (ClassNotFoundException e) {
            HAS_POSTGRES_DRIVER = false;
        }
    }
}

