/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimestampThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

@Deprecated
public class TimestampColumnLocalDateTimeMapper
extends AbstractTimestampThreeTenBPColumnMapper<LocalDateTime>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnLocalDateTimeMapper() {
    }

    public TimestampColumnLocalDateTimeMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalDateTime fromNonNullString(String s) {
        return LocalDateTime.parse((CharSequence)s);
    }

    @Override
    public LocalDateTime fromNonNullValue(Timestamp value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalDateTimeMapper.getDefault() : this.getDatabaseZone();
        Instant instant = Instant.ofEpochMilli((long)value.getTime());
        instant = instant.with((TemporalField)ChronoField.NANO_OF_SECOND, (long)value.getNanos());
        return LocalDateTime.ofInstant((Instant)instant, (ZoneId)currentDatabaseZone);
    }

    @Override
    public String toNonNullString(LocalDateTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(LocalDateTime value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalDateTimeMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zdt = value.atZone(currentDatabaseZone);
        Timestamp timestamp = new Timestamp(zdt.toInstant().toEpochMilli());
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of((String)zoneString);
    }
}

