/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Time;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimeThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;

@Deprecated
public class TimeColumnLocalTimeMapper
extends AbstractTimeThreeTenBPColumnMapper<LocalTime>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    private ZoneOffset databaseZone = null;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();

    public TimeColumnLocalTimeMapper() {
    }

    public TimeColumnLocalTimeMapper(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse((CharSequence)s);
    }

    @Override
    public LocalTime fromNonNullValue(Time value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnLocalTimeMapper.getDefault() : this.databaseZone;
        ZonedDateTime dateTime = Instant.ofEpochMilli((long)value.getTime()).atZone((ZoneId)currentDatabaseZone);
        LocalTime localTime = dateTime.toLocalTime();
        return localTime;
    }

    @Override
    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    @Override
    public Time toNonNullValue(LocalTime value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnLocalTimeMapper.getDefault() : this.databaseZone;
        OffsetDateTime zonedValue = LocalDateTime.of((int)1970, (int)1, (int)1, (int)value.getHour(), (int)value.getMinute(), (int)value.getSecond(), (int)value.getNano()).atOffset(currentDatabaseZone);
        Time time = new Time(zonedValue.toInstant().toEpochMilli());
        return time;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

