/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Date;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractDateThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.Month;
import org.threeten.bp.MonthDay;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.TemporalAccessor;

@Deprecated
public class DateColumnMonthDayMapper
extends AbstractDateThreeTenBPColumnMapper<MonthDay>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();

    public DateColumnMonthDayMapper() {
    }

    public DateColumnMonthDayMapper(ZoneOffset databaseZone) {
        super((ZoneId)databaseZone);
    }

    @Override
    public MonthDay fromNonNullString(String s) {
        return MonthDay.parse((CharSequence)s);
    }

    @Override
    public MonthDay fromNonNullValue(Date value) {
        if (this.getDatabaseZone() == null) {
            return MonthDay.parse((CharSequence)value.toString(), (DateTimeFormatter)LOCAL_DATE_FORMATTER);
        }
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime dateTime = ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)value.getTime()), (ZoneId)currentDatabaseZone);
        MonthDay localDate = MonthDay.of((Month)dateTime.getMonth(), (int)dateTime.getDayOfMonth());
        return localDate;
    }

    @Override
    public String toNonNullString(MonthDay value) {
        return value.toString();
    }

    @Override
    public Date toNonNullValue(MonthDay value) {
        if (this.getDatabaseZone() == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.format((TemporalAccessor)value));
        }
        LocalDate ldt = LocalDate.of((int)1970, (int)value.getMonthValue(), (int)value.getDayOfMonth());
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zonedValue = ldt.atStartOfDay((ZoneId)currentDatabaseZone);
        Date date = new Date(zonedValue.toInstant().toEpochMilli());
        return date;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

