/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Date;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractDateThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.TemporalAccessor;

@Deprecated
public class DateColumnLocalDateMapper
extends AbstractDateThreeTenBPColumnMapper<LocalDate>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();

    public DateColumnLocalDateMapper() {
    }

    public DateColumnLocalDateMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalDate fromNonNullString(String s) {
        return LocalDate.parse((CharSequence)s);
    }

    @Override
    public LocalDate fromNonNullValue(Date value) {
        if (this.getDatabaseZone() == null) {
            return LocalDate.parse((CharSequence)value.toString(), (DateTimeFormatter)LOCAL_DATE_FORMATTER);
        }
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime dateTime = ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)value.getTime()), (ZoneId)currentDatabaseZone);
        LocalDate localDate = dateTime.toLocalDate();
        return localDate;
    }

    @Override
    public String toNonNullString(LocalDate value) {
        return value.toString();
    }

    @Override
    public Date toNonNullValue(LocalDate value) {
        if (this.getDatabaseZone() == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.format((TemporalAccessor)value));
        }
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zonedValue = value.atStartOfDay(currentDatabaseZone);
        Date date = new Date(zonedValue.toInstant().toEpochMilli());
        return date;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of((String)zoneString);
    }
}

