/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimestampThreeTenColumnMapper;
import org.jadira.usertype.dateandtime.threeten.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public class TimestampColumnZonedDateTimeMapper
extends AbstractTimestampThreeTenColumnMapper<ZonedDateTime>
implements DatabaseZoneConfigured<ZoneId>,
JavaZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    private static final int MILLIS_IN_SECOND = 1000;
    private ZoneId javaZone = null;

    public TimestampColumnZonedDateTimeMapper() {
    }

    public TimestampColumnZonedDateTimeMapper(ZoneId databaseZone, ZoneId javaZone) {
        super(databaseZone);
        this.javaZone = javaZone;
    }

    @Override
    public ZonedDateTime fromNonNullString(String s) {
        return ZonedDateTime.parse(s);
    }

    @Override
    public ZonedDateTime fromNonNullValue(Timestamp value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? ZoneHelper.getDefaultZoneId() : this.getDatabaseZone();
        ZoneId currentJavaZone = this.javaZone == null ? ZoneHelper.getDefaultZoneId() : this.javaZone;
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(value.getTime()), currentDatabaseZone);
        dateTime = dateTime.with(ChronoField.NANO_OF_SECOND, value.getNanos()).withZoneSameInstant(currentJavaZone);
        return dateTime;
    }

    @Override
    public String toNonNullString(ZonedDateTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(ZonedDateTime value) {
        Timestamp timestamp = new Timestamp(value.toEpochSecond() * 1000L);
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    @Override
    public void setJavaZone(ZoneId javaZone) {
        this.javaZone = javaZone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

