/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimestampThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class TimestampColumnMonthDayMapper
extends AbstractTimestampThreeTenColumnMapper<MonthDay>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnMonthDayMapper() {
    }

    public TimestampColumnMonthDayMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public MonthDay fromNonNullString(String s) {
        return MonthDay.parse(s);
    }

    @Override
    public MonthDay fromNonNullValue(Timestamp value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        Instant instant = Instant.ofEpochMilli(value.getTime());
        instant = instant.with(ChronoField.NANO_OF_SECOND, value.getNanos());
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, currentDatabaseZone);
        return MonthDay.of(ldt.getMonth(), ldt.getDayOfMonth());
    }

    @Override
    public String toNonNullString(MonthDay value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(MonthDay value) {
        LocalDateTime ldt = LocalDateTime.of(1970, value.getMonthValue(), value.getDayOfMonth(), 0, 0);
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zdt = ldt.atZone(currentDatabaseZone);
        Timestamp timestamp = new Timestamp(zdt.toInstant().toEpochMilli());
        return timestamp;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of("Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

