/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimestampThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class TimestampColumnLocalTimeMapper
extends AbstractTimestampThreeTenColumnMapper<LocalTime>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = 1921591625617366103L;
    public static final DateTimeFormatter LOCAL_DATETIME_PRINTER = new DateTimeFormatterBuilder().appendPattern("0001-01-01 HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter LOCAL_DATETIME_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public TimestampColumnLocalTimeMapper() {
        super(null);
    }

    public TimestampColumnLocalTimeMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse(s);
    }

    @Override
    public LocalTime fromNonNullValue(Timestamp value) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(value.getTime());
        LocalTime time = LocalTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
        return time;
    }

    @Override
    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(LocalTime value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalTimeMapper.getDefault() : this.getDatabaseZone();
        LocalDateTime ldt = LocalDateTime.of(1970, Month.JANUARY, 1, value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
        ZonedDateTime zdt = ldt.atZone(currentDatabaseZone);
        Instant ins = zdt.toInstant();
        Timestamp timestamp = new Timestamp(ins.toEpochMilli());
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of("Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

