/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimestampThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class TimestampColumnLocalDateTimeMapper
extends AbstractTimestampThreeTenColumnMapper<LocalDateTime>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnLocalDateTimeMapper() {
    }

    public TimestampColumnLocalDateTimeMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalDateTime fromNonNullString(String s) {
        return LocalDateTime.parse(s);
    }

    @Override
    public LocalDateTime fromNonNullValue(Timestamp value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalDateTimeMapper.getDefault() : this.getDatabaseZone();
        Instant instant = Instant.ofEpochMilli(value.getTime());
        instant = instant.with(ChronoField.NANO_OF_SECOND, value.getNanos());
        return LocalDateTime.ofInstant(instant, currentDatabaseZone);
    }

    @Override
    public String toNonNullString(LocalDateTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(LocalDateTime value) {
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalDateTimeMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zdt = value.atZone(currentDatabaseZone);
        Timestamp timestamp = new Timestamp(zdt.toInstant().toEpochMilli());
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of("Z");
        }
        return zone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of(zoneString);
    }
}

