/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimestampThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class TimestampColumnInstantMapper
extends AbstractTimestampThreeTenColumnMapper<Instant>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnInstantMapper() {
    }

    public TimestampColumnInstantMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public Instant fromNonNullString(String s) {
        return Instant.parse(s);
    }

    @Override
    public Instant fromNonNullValue(Timestamp value) {
        Instant instant = Instant.ofEpochMilli(value.getTime());
        instant = instant.with(ChronoField.NANO_OF_SECOND, value.getNanos());
        return instant;
    }

    @Override
    public String toNonNullString(Instant value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(Instant value) {
        Timestamp timestamp = new Timestamp(value.toEpochMilli());
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

