/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Time;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimeThreeTenColumnMapper;
import org.jadira.usertype.dateandtime.threeten.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public class TimeColumnOffsetTimeMapper
extends AbstractTimeThreeTenColumnMapper<OffsetTime>
implements DatabaseZoneConfigured<ZoneOffset>,
JavaZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();
    private ZoneOffset databaseZone = ZoneOffset.UTC;
    private ZoneOffset javaZone = null;

    public TimeColumnOffsetTimeMapper() {
    }

    public TimeColumnOffsetTimeMapper(ZoneOffset databaseZone, ZoneOffset javaZone) {
        this.databaseZone = databaseZone;
        this.javaZone = javaZone;
    }

    @Override
    public OffsetTime fromNonNullString(String s) {
        return OffsetTime.parse(s);
    }

    @Override
    public OffsetTime fromNonNullValue(Time value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnOffsetTimeMapper.getDefault() : this.databaseZone;
        OffsetDateTime dateTime = Instant.ofEpochMilli(value.getTime()).atOffset(currentDatabaseZone);
        return dateTime.toOffsetTime().withOffsetSameInstant(this.javaZone);
    }

    @Override
    public String toNonNullString(OffsetTime value) {
        return value.toString();
    }

    @Override
    public Time toNonNullValue(OffsetTime value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefaultZoneOffset() : this.databaseZone;
        OffsetTime adjustedValue = value.withOffsetSameInstant(currentDatabaseZone);
        return Time.valueOf(LOCAL_TIME_FORMATTER.format(adjustedValue));
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of("Z");
        }
        return zone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public void setJavaZone(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of(zoneString);
    }
}

