/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractTimeThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class TimeColumnLocalTimeMapper
extends AbstractTimeThreeTenColumnMapper<LocalTime>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    private ZoneOffset databaseZone = null;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();

    public TimeColumnLocalTimeMapper() {
    }

    public TimeColumnLocalTimeMapper(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse(s);
    }

    @Override
    public LocalTime fromNonNullValue(Time value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnLocalTimeMapper.getDefault() : this.databaseZone;
        ZonedDateTime dateTime = Instant.ofEpochMilli(value.getTime()).atZone(currentDatabaseZone);
        LocalTime localTime = dateTime.toLocalTime();
        return localTime;
    }

    @Override
    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    @Override
    public Time toNonNullValue(LocalTime value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnLocalTimeMapper.getDefault() : this.databaseZone;
        OffsetDateTime zonedValue = LocalDateTime.of(1970, 1, 1, value.getHour(), value.getMinute(), value.getSecond(), value.getNano()).atOffset(currentDatabaseZone);
        Time time = new Time(zonedValue.toInstant().toEpochMilli());
        return time;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of("Z");
        }
        return zone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of(zoneString);
    }
}

