/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.math.BigInteger;
import java.time.Duration;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;

public class LongColumnDurationMapper
extends AbstractLongColumnMapper<Duration> {
    private static final long serialVersionUID = 8408450977695192938L;
    private static final BigInteger NANOS_IN_MILLI = BigInteger.valueOf(1000000L);
    private static final BigInteger MILLIS_IN_SECOND = BigInteger.valueOf(1000L);

    @Override
    public Duration fromNonNullString(String s) {
        return Duration.parse(s);
    }

    @Override
    public Duration fromNonNullValue(Long value) {
        return Duration.ofMillis(value);
    }

    @Override
    public String toNonNullString(Duration value) {
        return value.toString();
    }

    @Override
    public Long toNonNullValue(Duration value) {
        BigInteger millisValue = BigInteger.valueOf(value.getNano()).divide(NANOS_IN_MILLI).add(BigInteger.valueOf(value.getSeconds()).multiply(MILLIS_IN_SECOND));
        return millisValue.longValueExact();
    }
}

