/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractDateThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class DateColumnMonthDayMapper
extends AbstractDateThreeTenColumnMapper<MonthDay>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();

    public DateColumnMonthDayMapper() {
    }

    public DateColumnMonthDayMapper(ZoneId databaseZone) {
        super(databaseZone);
    }

    @Override
    public MonthDay fromNonNullString(String s) {
        return MonthDay.parse(s);
    }

    @Override
    public MonthDay fromNonNullValue(Date value) {
        if (this.getDatabaseZone() == null) {
            return MonthDay.parse(value.toString(), LOCAL_DATE_FORMATTER);
        }
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(value.getTime()), currentDatabaseZone);
        MonthDay localDate = MonthDay.of(dateTime.getMonth(), dateTime.getDayOfMonth());
        return localDate;
    }

    @Override
    public String toNonNullString(MonthDay value) {
        return value.toString();
    }

    @Override
    public Date toNonNullValue(MonthDay value) {
        if (this.getDatabaseZone() == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.format(value));
        }
        LocalDate ldt = LocalDate.of(1970, value.getMonthValue(), value.getDayOfMonth());
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zonedValue = ldt.atStartOfDay(currentDatabaseZone);
        Date date = new Date(zonedValue.toInstant().toEpochMilli());
        return date;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of("Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

