/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threeten.columnmapper.AbstractDateThreeTenColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;

public class DateColumnLocalDateMapper
extends AbstractDateThreeTenColumnMapper<LocalDate>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();

    public DateColumnLocalDateMapper() {
    }

    public DateColumnLocalDateMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalDate fromNonNullString(String s) {
        return LocalDate.parse(s);
    }

    @Override
    public LocalDate fromNonNullValue(Date value) {
        if (this.getDatabaseZone() == null) {
            return LocalDate.parse(value.toString(), LOCAL_DATE_FORMATTER);
        }
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(value.getTime()), currentDatabaseZone);
        LocalDate localDate = dateTime.toLocalDate();
        return localDate;
    }

    @Override
    public String toNonNullString(LocalDate value) {
        return value.toString();
    }

    @Override
    public Date toNonNullValue(LocalDate value) {
        if (this.getDatabaseZone() == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.format(value));
        }
        ZoneId currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zonedValue = value.atStartOfDay(currentDatabaseZone);
        Date date = new Date(zonedValue.toInstant().toEpochMilli());
        return date;
    }

    private static ZoneId getDefault() {
        ZoneId zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneId.of(id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneId.of(TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneId.of("Z");
        }
        return zone;
    }

    @Override
    public ZoneId parseZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

