/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.math.BigDecimal;
import java.time.Duration;
import org.jadira.usertype.spi.shared.AbstractBigDecimalColumnMapper;

public class BigDecimalColumnDurationMapper
extends AbstractBigDecimalColumnMapper<Duration> {
    private static final long serialVersionUID = 8408450977695192938L;
    private static final BigDecimal NANOS_IN_SECOND = BigDecimal.valueOf(1000000000L);

    @Override
    public Duration fromNonNullString(String s) {
        return Duration.parse(s);
    }

    @Override
    public Duration fromNonNullValue(BigDecimal value) {
        StringBuilder durationPattern = new StringBuilder();
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            durationPattern.append('-');
        }
        durationPattern.append("PT");
        durationPattern.append(value.abs().toPlainString());
        durationPattern.append("S");
        return Duration.parse(durationPattern.toString());
    }

    @Override
    public String toNonNullString(Duration value) {
        return value.toString();
    }

    @Override
    public BigDecimal toNonNullValue(Duration value) {
        return BigDecimal.valueOf(value.getSeconds()).add(BigDecimal.valueOf(value.getNano()).divide(NANOS_IN_SECOND));
    }
}

