/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;

public abstract class AbstractTimestampThreeTenColumnMapper<T>
extends AbstractVersionableTimestampColumnMapper<T>
implements DatabaseZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    private ZoneId databaseZone = ZoneOffset.of("Z");

    public AbstractTimestampThreeTenColumnMapper() {
    }

    public AbstractTimestampThreeTenColumnMapper(ZoneId databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public void setDatabaseZone(ZoneId databaseZone) {
        this.databaseZone = databaseZone;
    }

    protected ZoneId getDatabaseZone() {
        return this.databaseZone;
    }

    @Override
    public final DstSafeTimestampType getHibernateType() {
        if (this.databaseZone == null) {
            return DstSafeTimestampType.INSTANCE;
        }
        Calendar cal = this.resolveCalendar(this.databaseZone);
        if (cal == null) {
            throw new IllegalStateException("Could not map Zone " + this.databaseZone + " to Calendar");
        }
        return new DstSafeTimestampType(cal);
    }

    private Calendar resolveCalendar(ZoneId databaseZone) {
        String id = databaseZone.getId();
        if (Arrays.binarySearch(TimeZone.getAvailableIDs(), id) != -1) {
            return Calendar.getInstance(TimeZone.getTimeZone(id));
        }
        return null;
    }
}

