/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.jadira.usertype.spi.shared.AbstractTimeColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimeType;

public abstract class AbstractTimeThreeTenColumnMapper<T>
extends AbstractTimeColumnMapper<T>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = -7670411089210984705L;
    private ZoneOffset databaseZone = ZoneOffset.of("Z");

    public AbstractTimeThreeTenColumnMapper() {
    }

    public AbstractTimeThreeTenColumnMapper(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    protected ZoneOffset getDatabaseZone() {
        return this.databaseZone;
    }

    @Override
    public final DstSafeTimeType getHibernateType() {
        if (this.databaseZone == null) {
            return DstSafeTimeType.INSTANCE;
        }
        Calendar cal = this.resolveCalendar(this.databaseZone);
        if (cal == null) {
            throw new IllegalStateException("Could not map Zone " + this.databaseZone + " to Calendar");
        }
        return new DstSafeTimeType(cal);
    }

    private Calendar resolveCalendar(ZoneOffset databaseZone) {
        String id = databaseZone.getId();
        if (Arrays.binarySearch(TimeZone.getAvailableIDs(), id) != -1) {
            return Calendar.getInstance(TimeZone.getTimeZone(id));
        }
        return null;
    }
}

