/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractTimestampColumnMapper;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class TimestampColumnLocalDateTimeMapper
extends AbstractTimestampColumnMapper<LocalDateTime>
implements ColumnMapper<LocalDateTime, Timestamp>,
DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = -7670411089210984705L;
    private DateTimeZone databaseZone = null;

    public TimestampColumnLocalDateTimeMapper() {
    }

    public TimestampColumnLocalDateTimeMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public LocalDateTime fromNonNullString(String s) {
        return new LocalDateTime(s);
    }

    @Override
    public LocalDateTime fromNonNullValue(Timestamp value) {
        DateTime dateTime = new DateTime(value.getTime());
        LocalDateTime localDateTime = dateTime.toLocalDateTime();
        return localDateTime;
    }

    @Override
    public String toNonNullString(LocalDateTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(LocalDateTime value) {
        DateTime zonedValue = value.toDateTime(value.toDateTime());
        Timestamp timestamp = new Timestamp(zonedValue.getMillis());
        return timestamp;
    }

    @Override
    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID(zoneString);
    }

    @Override
    public final DstSafeTimestampType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimestampType.INSTANCE : new DstSafeTimestampType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

