/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.corejava.collections;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.jadira.usertype.spi.shared.AbstractMapUserType;

public class PersistentStringMapAsJson
extends AbstractMapUserType<String, String> {
    private static final long serialVersionUID = 2579662814723772780L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ObjectReader OBJECT_READER = OBJECT_MAPPER.readerFor(new TypeReference<Map<String, String>>(){});
    private ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writerFor(new TypeReference<Map<String, String>>(){});

    protected ObjectReader getObjectReader() {
        return this.OBJECT_READER;
    }

    protected ObjectWriter getObjectWriter() {
        return this.OBJECT_WRITER;
    }

    @Override
    protected String toString(Map<String, String> map) {
        try {
            return this.OBJECT_WRITER.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException("Cannot serialize JSON object: " + e.getMessage(), e);
        }
    }

    @Override
    protected Map<String, String> toMap(String input) {
        try {
            Object obj = this.getObjectReader().readValue(input);
            return (Map)obj;
        }
        catch (JsonParseException e) {
            throw new HibernateException("Problem parsing retrieved JSON String: " + input, e);
        }
        catch (JsonMappingException e) {
            throw new HibernateException("Problem mapping retrieved JSON String: " + input, e);
        }
        catch (IOException e) {
            throw new HibernateException("Problem reading JSON String: " + input, e);
        }
    }
}

