/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.corejava.collections;

import java.util.HashMap;
import java.util.Map;
import org.jadira.usertype.spi.shared.AbstractMapUserType;

public class PersistentStringMap
extends AbstractMapUserType<String, String> {
    private static final long serialVersionUID = 8279418608033058332L;

    @Override
    protected String toString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            key = key.replaceAll("&(?!amp;)", "&amp;");
            value = value.replaceAll("&(?!amp;)", "&amp;");
            key = key.replaceAll("=", "&equals;");
            value = value.replaceAll("=", "&equals;");
            key = key.replaceAll(",", "&comma;");
            value = value.replaceAll(",", "&comma;");
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(key);
            if (value == null) continue;
            sb.append("=").append(value);
        }
        return sb.toString();
    }

    @Override
    protected Map<String, String> toMap(String input) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String next : input.split("\n")) {
            String value;
            String key;
            int i = next.indexOf("=");
            if (i == -1) {
                key = next;
                value = null;
            } else {
                key = next.substring(0, i);
                value = next.substring(i + 1);
                value = value.replaceAll("[&]comma[;]", ",");
                value = value.replaceAll("[&]equals[;]", "=");
                value = value.replaceAll("[&]amp[;]", "&");
            }
            key = key.replaceAll("[&]comma[;]", ",");
            key = key.replaceAll("[&]equals[;]", "=");
            key = key.replaceAll("[&]amp[;]", "&");
            map.put(key, value);
        }
        return map;
    }
}

