/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.NoopOptimizer;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SequenceStyleGenerator.class.getName());
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String CONFIG_PREFER_SEQUENCE_PER_ENTITY = "prefer_sequence_per_entity";
    public static final String CONFIG_SEQUENCE_PER_ENTITY_SUFFIX = "sequence_per_entity_suffix";
    public static final String DEF_SEQUENCE_SUFFIX = "_SEQ";
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        Dialect dialect = jdbcEnvironment.getDialect();
        this.identifierType = type;
        boolean forceTableUse = ConfigurationHelper.getBoolean(FORCE_TBL_PARAM, params, false);
        QualifiedName sequenceName = this.determineSequenceName(params, dialect, jdbcEnvironment);
        int initialValue = this.determineInitialValue(params);
        int incrementSize = this.determineIncrementSize(params);
        String optimizationStrategy = this.determineOptimizationStrategy(params, incrementSize);
        incrementSize = this.determineAdjustedIncrementSize(optimizationStrategy, incrementSize);
        if (dialect.supportsSequences() && !forceTableUse && !dialect.supportsPooledSequences() && OptimizerFactory.isPooledOptimizer(optimizationStrategy)) {
            forceTableUse = true;
            LOG.forcingTableUse();
        }
        this.databaseStructure = this.buildDatabaseStructure(type, params, jdbcEnvironment, forceTableUse, sequenceName, initialValue, incrementSize);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), incrementSize, ConfigurationHelper.getInt(INITIAL_PARAM, params, -1));
        this.databaseStructure.prepare(this.optimizer);
    }

    protected QualifiedName determineSequenceName(Properties params, Dialect dialect, JdbcEnvironment jdbcEnv) {
        String sequencePerEntitySuffix = ConfigurationHelper.getString(CONFIG_SEQUENCE_PER_ENTITY_SUFFIX, params, DEF_SEQUENCE_SUFFIX);
        String defaultSequenceName = ConfigurationHelper.getBoolean(CONFIG_PREFER_SEQUENCE_PER_ENTITY, params, false) ? params.getProperty("jpa_entity_name") + sequencePerEntitySuffix : DEF_SEQUENCE_NAME;
        String sequenceName = ConfigurationHelper.getString(SEQUENCE_PARAM, params, defaultSequenceName);
        if (sequenceName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("catalog", params));
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("schema", params));
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
    }

    protected Identifier determineValueColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt(INITIAL_PARAM, params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt(INCREMENT_PARAM, params, 1);
    }

    protected String determineOptimizationStrategy(Properties params, int incrementSize) {
        return ConfigurationHelper.getString(OPT_PARAM, params, OptimizerFactory.determineImplicitOptimizerName(incrementSize, params));
    }

    protected int determineAdjustedIncrementSize(String optimizationStrategy, int incrementSize) {
        if (incrementSize > 1 && StandardOptimizerDescriptor.NONE.getExternalName().equals(optimizationStrategy)) {
            LOG.honoringOptimizerSetting(StandardOptimizerDescriptor.NONE.getExternalName(), INCREMENT_PARAM, incrementSize);
            incrementSize = 1;
        }
        return incrementSize;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, boolean forceTableUse, QualifiedName sequenceName, int initialValue, int incrementSize) {
        boolean useSequence;
        boolean bl = useSequence = jdbcEnvironment.getDialect().supportsSequences() && !forceTableUse;
        if (useSequence) {
            return this.buildSequenceStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
        }
        return this.buildTableStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
    }

    protected DatabaseStructure buildSequenceStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        return new SequenceStructure(jdbcEnvironment, sequenceName, initialValue, incrementSize, type.getReturnedClass());
    }

    protected DatabaseStructure buildTableStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        Identifier valueColumnName = this.determineValueColumnName(params, jdbcEnvironment);
        return new TableStructure(jdbcEnvironment, sequenceName, valueColumnName, initialValue, incrementSize, type.getReturnedClass());
    }

    @Override
    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(session));
    }

    @Override
    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }

    @Override
    public boolean supportsBulkInsertionIdentifierGeneration() {
        return NoopOptimizer.class.isInstance(this.getOptimizer()) && this.getDatabaseStructure().isPhysicalSequence();
    }

    @Override
    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getDatabaseStructure().getName());
    }

    @Override
    public void registerExportables(Database database) {
        this.databaseStructure.registerExportables(database);
    }
}

