/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class UpdateTimestampsCache {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, UpdateTimestampsCache.class.getName());
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private final SessionFactoryImplementor factory;
    private final TimestampsRegion region;

    public UpdateTimestampsCache(SessionFactoryImplementor sessionFactory, TimestampsRegion region) {
        LOG.startingUpdateTimestampsCache(region.getName());
        this.factory = sessionFactory;
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvalidate(Serializable[] spaces, SharedSessionContractImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long ts = this.region.nextTimestamp() + (long)this.region.getTimeout();
        for (Serializable space : spaces) {
            if (DEBUG_ENABLED) {
                LOG.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.region.put(session, space, ts);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
            }
            if (!stats) continue;
            this.factory.getStatistics().updateTimestampsCachePut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Serializable[] spaces, SharedSessionContractImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long ts = this.region.nextTimestamp();
        for (Serializable space : spaces) {
            if (DEBUG_ENABLED) {
                LOG.debugf("Invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.region.put(session, space, ts);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
            }
            if (!stats) continue;
            this.factory.getStatistics().updateTimestampsCachePut();
        }
    }

    public boolean isUpToDate(Set<Serializable> spaces, Long timestamp, SharedSessionContractImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        for (Serializable space : spaces) {
            Long lastUpdate = this.getLastUpdateTimestampForSpace(space, session);
            if (lastUpdate == null) {
                if (!stats) continue;
                this.factory.getStatistics().updateTimestampsCacheMiss();
                continue;
            }
            if (DEBUG_ENABLED) {
                LOG.debugf("[%s] last update timestamp: %s", (Object)space, (Object)(lastUpdate + ", result set timestamp: " + timestamp));
            }
            if (stats) {
                this.factory.getStatistics().updateTimestampsCacheHit();
            }
            if (lastUpdate < timestamp) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastUpdateTimestampForSpace(Serializable space, SharedSessionContractImplementor session) {
        Long ts = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            ts = (Long)this.region.get(session, space);
            session.getEventListenerManager().cacheGetEnd(ts != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(ts != null);
            throw throwable;
        }
        return ts;
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyUpdateTimestampsCache(this.region.getName(), e.getMessage());
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampsCache";
    }
}

