/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.hibernate.AnnotationException;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.spi.AttributeConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.cfg.annotations.HCANNHelper;

public class AttributeConverterDescriptorImpl
implements AttributeConverterDescriptor {
    private final AttributeConverter attributeConverter;
    private final boolean autoApply;
    private final ResolvedType domainType;
    private final ResolvedType jdbcType;

    public static AttributeConverterDescriptor create(AttributeConverterDefinition definition, ClassmateContext classmateContext) {
        AttributeConverter converter = definition.getAttributeConverter();
        Class<?> converterClass = converter.getClass();
        ResolvedType converterType = classmateContext.getTypeResolver().resolve(converterClass, new Type[0]);
        List<ResolvedType> converterParamTypes = converterType.typeParametersFor(AttributeConverter.class);
        if (converterParamTypes == null) {
            throw new AnnotationException("Could not extract type parameter information from AttributeConverter implementation [" + converterClass.getName() + "]");
        }
        if (converterParamTypes.size() != 2) {
            throw new AnnotationException("Unexpected type parameter information for AttributeConverter implementation [" + converterClass.getName() + "]; expected 2 parameter types, but found " + converterParamTypes.size());
        }
        return new AttributeConverterDescriptorImpl(converter, definition.isAutoApply(), converterParamTypes.get(0), converterParamTypes.get(1));
    }

    private AttributeConverterDescriptorImpl(AttributeConverter attributeConverter, boolean autoApply, ResolvedType domainType, ResolvedType jdbcType) {
        this.attributeConverter = attributeConverter;
        this.autoApply = autoApply;
        this.domainType = domainType;
        this.jdbcType = jdbcType;
    }

    @Override
    public AttributeConverter getAttributeConverter() {
        return this.attributeConverter;
    }

    @Override
    public Class<?> getDomainType() {
        return this.domainType.getErasedType();
    }

    @Override
    public Class<?> getJdbcType() {
        return this.jdbcType.getErasedType();
    }

    @Override
    public boolean shouldAutoApplyToAttribute(XProperty xProperty, MetadataBuildingContext context) {
        if (!this.autoApply) {
            return false;
        }
        ResolvedType attributeType = this.resolveAttributeType(xProperty, context);
        return this.typesMatch(this.domainType, attributeType);
    }

    private ResolvedType resolveAttributeType(XProperty xProperty, MetadataBuildingContext context) {
        return this.resolveMember(xProperty, context).getType();
    }

    private ResolvedMember resolveMember(XProperty xProperty, MetadataBuildingContext buildingContext) {
        ClassmateContext classmateContext = buildingContext.getMetadataCollector().getClassmateContext();
        ReflectionManager reflectionManager = buildingContext.getBuildingOptions().getReflectionManager();
        ResolvedType declaringClassType = classmateContext.getTypeResolver().resolve(reflectionManager.toClass(xProperty.getDeclaringClass()), new Type[0]);
        ResolvedTypeWithMembers declaringClassWithMembers = classmateContext.getMemberResolver().resolve(declaringClassType, null, null);
        Member member = AttributeConverterDescriptorImpl.toMember(xProperty);
        if (member instanceof Method) {
            for (ResolvedMethod resolvedMember : declaringClassWithMembers.getMemberMethods()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else if (member instanceof Field) {
            for (ResolvedField resolvedMember : declaringClassWithMembers.getMemberFields()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else {
            throw new HibernateException("Unexpected java.lang.reflect.Member type from org.hibernate.annotations.common.reflection.java.JavaXMember : " + member);
        }
        throw new HibernateException("Could not locate resolved type information for attribute [" + member.getName() + "] from Classmate");
    }

    private static Member toMember(XProperty xProperty) {
        try {
            return HCANNHelper.getUnderlyingMember(xProperty);
        }
        catch (Exception e) {
            throw new HibernateException("Could not resolve member signature from XProperty reference", e);
        }
    }

    private boolean typesMatch(ResolvedType converterDefinedType, ResolvedType checkType) {
        if (!converterDefinedType.getErasedType().isAssignableFrom(checkType.getErasedType())) {
            return false;
        }
        if (converterDefinedType.getTypeParameters().isEmpty()) {
            return true;
        }
        if (checkType.getTypeParameters().isEmpty()) {
            return false;
        }
        if (converterDefinedType.getTypeParameters().size() != checkType.getTypeParameters().size()) {
            return false;
        }
        for (int i = 0; i < converterDefinedType.getTypeParameters().size(); ++i) {
            if (this.typesMatch(converterDefinedType.getTypeParameters().get(i), checkType.getTypeParameters().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldAutoApplyToCollectionElement(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedType elementType;
        if (!this.autoApply) {
            return false;
        }
        ResolvedMember collectionMember = this.resolveMember(xProperty, context);
        if (Map.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            elementType = collectionMember.getType().typeParametersFor(Map.class).get(1);
        } else if (Collection.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            elementType = collectionMember.getType().typeParametersFor(Collection.class).get(0);
        } else {
            throw new HibernateException("Attribute was neither a Collection nor a Map : " + collectionMember.getType().getErasedType());
        }
        return this.typesMatch(this.domainType, elementType);
    }

    @Override
    public boolean shouldAutoApplyToMapKey(XProperty xProperty, MetadataBuildingContext context) {
        if (!this.autoApply) {
            return false;
        }
        ResolvedMember collectionMember = this.resolveMember(xProperty, context);
        if (!Map.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            throw new HibernateException("Attribute was not a Map : " + collectionMember.getType().getErasedType());
        }
        ResolvedType keyType = collectionMember.getType().typeParametersFor(Map.class).get(0);
        return this.typesMatch(this.domainType, keyType);
    }
}

