/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.gluu.oxd.Oxd;
import org.xdi.oxauth.model.common.IntrospectionResponse;
import org.xdi.oxd.common.params.GetAuthorizationUrlParams;
import org.xdi.oxd.common.params.GetClientTokenParams;
import org.xdi.oxd.common.params.GetLogoutUrlParams;
import org.xdi.oxd.common.params.GetTokensByCodeParams;
import org.xdi.oxd.common.params.GetUserInfoParams;
import org.xdi.oxd.common.params.RegisterSiteParams;
import org.xdi.oxd.common.params.SetupClientParams;
import org.xdi.oxd.common.params.UpdateSiteParams;
import org.xdi.oxd.common.response.GetTokensByCodeResponse;
import org.xdi.oxd.common.response.RegisterSiteResponse;
import org.xdi.oxd.common.response.SetupClientResponse;
import org.xdi.oxd.common.response.UpdateSiteResponse;
import org.xdi.oxd.rs.protect.Jackson;

@Path(value="/")
public class RestResource {
    @POST
    @Path(value="/setup-client")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public SetupClientResponse setupClient(String params) throws IOException {
        return Oxd.setupClient(RestResource.read(params, SetupClientParams.class));
    }

    @GET
    @Path(value="/health-check")
    @Produces(value={"application/json"})
    public String healthCheck() {
        return "running";
    }

    @POST
    @Path(value="/register-site")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RegisterSiteResponse registerSite(String params) throws IOException {
        return Oxd.registerSite(RestResource.read(params, RegisterSiteParams.class));
    }

    @POST
    @Path(value="/update-site")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public UpdateSiteResponse updateSite(String params) throws IOException {
        return Oxd.updateSite(RestResource.read(params, UpdateSiteParams.class));
    }

    @POST
    @Path(value="/get-authorization-url")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object getAuthrizationUrl(String params) throws IOException {
        return Oxd.getAuthorizationUrlResponse(RestResource.read(params, GetAuthorizationUrlParams.class));
    }

    private static <T> T read(String params, Class<T> clazz) throws IOException {
        return Jackson.createJsonMapper().readValue(params, clazz);
    }

    @POST
    @Path(value="/get-tokens-by-code")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public GetTokensByCodeResponse getTokenByCode(String params) throws IOException {
        return Oxd.getTokenByCode(RestResource.read(params, GetTokensByCodeParams.class));
    }

    @POST
    @Path(value="/get-user-info")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object getUserInfo(String params) throws IOException {
        return Oxd.getUserInfo(RestResource.read(params, GetUserInfoParams.class));
    }

    @POST
    @Path(value="/get-client-token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object getClientToken(String params) throws IOException {
        return Oxd.getClientToken(RestResource.read(params, GetClientTokenParams.class));
    }

    @POST
    @Path(value="/logout")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object getLogoutUrl(String params) throws IOException {
        return Oxd.getLogoutUri(RestResource.read(params, GetLogoutUrlParams.class));
    }

    @POST
    @Path(value="/introspect")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public IntrospectionResponse introspectAccessToken(@FormParam(value="token") String token) throws IOException {
        return Oxd.introspectAccesstoken(token);
    }
}

