/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.xdi.oxauth.client.service.ClientFactory;
import org.xdi.oxauth.client.service.IntrospectionService;
import org.xdi.oxauth.model.common.IntrospectionResponse;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.GetAuthorizationUrlParams;
import org.xdi.oxd.common.params.GetClientTokenParams;
import org.xdi.oxd.common.params.GetLogoutUrlParams;
import org.xdi.oxd.common.params.GetTokensByCodeParams;
import org.xdi.oxd.common.params.GetUserInfoParams;
import org.xdi.oxd.common.params.RegisterSiteParams;
import org.xdi.oxd.common.params.SetupClientParams;
import org.xdi.oxd.common.params.UpdateSiteParams;
import org.xdi.oxd.common.response.GetAuthorizationUrlResponse;
import org.xdi.oxd.common.response.GetClientTokenResponse;
import org.xdi.oxd.common.response.GetTokensByCodeResponse;
import org.xdi.oxd.common.response.GetUserInfoResponse;
import org.xdi.oxd.common.response.LogoutResponse;
import org.xdi.oxd.common.response.RegisterSiteResponse;
import org.xdi.oxd.common.response.SetupClientResponse;
import org.xdi.oxd.common.response.UpdateSiteResponse;

public class Oxd {
    private final Properties configProp = new Properties();

    private Oxd() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("config.properties");
        try {
            this.configProp.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SetupClientResponse setupClient(SetupClientParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.SETUP_CLIENT);
            command.setParamsObject(params);
            SetupClientResponse setupClientResponse = client.send(command).dataAsResponse(SetupClientResponse.class);
            return setupClientResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegisterSiteResponse registerSite(RegisterSiteParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.REGISTER_SITE);
            command.setParamsObject(params);
            RegisterSiteResponse registerSiteResponse = client.send(command).dataAsResponse(RegisterSiteResponse.class);
            return registerSiteResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateSiteResponse updateSite(UpdateSiteParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.UPDATE_SITE);
            command.setParamsObject(params);
            UpdateSiteResponse updateSiteResponse = client.send(command).dataAsResponse(UpdateSiteResponse.class);
            return updateSiteResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetAuthorizationUrlResponse getAuthorizationUrlResponse(GetAuthorizationUrlParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.GET_AUTHORIZATION_URL);
            command.setParamsObject(params);
            GetAuthorizationUrlResponse getAuthorizationUrlResponse = client.send(command).dataAsResponse(GetAuthorizationUrlResponse.class);
            return getAuthorizationUrlResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetTokensByCodeResponse getTokenByCode(GetTokensByCodeParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.GET_TOKENS_BY_CODE);
            command.setParamsObject(params);
            GetTokensByCodeResponse getTokensByCodeResponse = client.send(command).dataAsResponse(GetTokensByCodeResponse.class);
            return getTokensByCodeResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetUserInfoResponse getUserInfo(GetUserInfoParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            GetUserInfoResponse getUserInfoResponse = client.send(new Command(CommandType.GET_USER_INFO).setParamsObject(params)).dataAsResponse(GetUserInfoResponse.class);
            return getUserInfoResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetClientTokenResponse getClientToken(GetClientTokenParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            GetClientTokenResponse getClientTokenResponse = client.send(new Command(CommandType.GET_CLIENT_TOKEN).setParamsObject(params)).dataAsResponse(GetClientTokenResponse.class);
            return getClientTokenResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    private static CommandClient newClient() throws IOException {
        return new CommandClient(Oxd.getInstance().getProperty("DEFAULT_HOST"), Integer.parseInt(Oxd.getInstance().getProperty("DEFAULT_PORT")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogoutResponse getLogoutUri(GetLogoutUrlParams params) throws IOException {
        CommandClient client = null;
        try {
            client = Oxd.newClient();
            Command command = new Command(CommandType.GET_LOGOUT_URI);
            command.setParamsObject(params);
            LogoutResponse logoutResponse = client.send(command).dataAsResponse(LogoutResponse.class);
            return logoutResponse;
        }
        finally {
            CommandClient.closeQuietly(client);
        }
    }

    public static IntrospectionResponse introspectAccesstoken(String token) throws IOException {
        IntrospectionService introspectionService = ClientFactory.instance().createIntrospectionService(Oxd.getInstance().getProperty("DEFAULT_INTROSPECTION_ENDPOINTHTTP"));
        return introspectionService.introspectToken("Bearer " + token, token);
    }

    public static Oxd getInstance() {
        return LazyHolder.INSTANCE;
    }

    public String getProperty(String key) {
        return this.configProp.getProperty(key);
    }

    public Set<String> getAllPropertyNames() {
        return this.configProp.stringPropertyNames();
    }

    public boolean containsKey(String key) {
        return this.configProp.containsKey(key);
    }

    private static class LazyHolder {
        private static final Oxd INSTANCE = new Oxd();

        private LazyHolder() {
        }
    }
}

