/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.server;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;

public class ALPNServerConnectionFactory
extends NegotiatingServerConnectionFactory
implements SslHandshakeListener {
    private final ALPNProcessor.Server alpnProcessor;

    public ALPNServerConnectionFactory(String protocols) {
        this(protocols.trim().split(",", 0));
    }

    public ALPNServerConnectionFactory(String ... protocols) {
        super("alpn", protocols);
        ALPNServerConnectionFactory.checkProtocolNegotiationAvailable();
        Iterator<ALPNProcessor.Server> processors = ServiceLoader.load(ALPNProcessor.Server.class).iterator();
        this.alpnProcessor = processors.hasNext() ? processors.next() : ALPNProcessor.Server.NOOP;
    }

    public ALPNProcessor.Server getALPNProcessor() {
        return this.alpnProcessor;
    }

    @Override
    protected AbstractConnection newServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        this.getALPNProcessor().configure(engine);
        return new ALPNServerConnection(connector, endPoint, engine, protocols, defaultProtocol);
    }

    @Override
    public void handshakeSucceeded(SslHandshakeListener.Event event) {
        if (this.alpnProcessor instanceof SslHandshakeListener) {
            ((SslHandshakeListener)((Object)this.alpnProcessor)).handshakeSucceeded(event);
        }
    }

    @Override
    public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
        if (this.alpnProcessor instanceof SslHandshakeListener) {
            ((SslHandshakeListener)((Object)this.alpnProcessor)).handshakeFailed(event, failure);
        }
    }
}

