/*
 * Decompiled with CFR 0.152.
 */
package liquibase.osgi;

import java.util.Collection;
import java.util.Set;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OSGiPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final Bundle bundle;

    public OSGiPackageScanClassResolver(Bundle bundle2) {
        this.bundle = bundle2;
    }

    @Override
    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        BundleWiring bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        Collection names = bundleWiring.listResources(packageName = packageName.replace('.', '/'), "*.class", 1);
        if (names == null) {
            return;
        }
        ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
        for (String name : names) {
            String fixedName = name.substring(0, name.indexOf(46)).replace('/', '.');
            try {
                Class<?> klass = bundleClassLoader.loadClass(fixedName);
                if (!test.matches(klass)) continue;
                classes.add(klass);
            }
            catch (ClassNotFoundException e) {
                this.log.debug("Cant load class: " + e.getMessage());
            }
        }
    }
}

