/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sslreload;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.Bundle;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.SslReload;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.sslreload.SslReloadTask;
import java.util.Collection;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslReloadBundle
implements Bundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslReloadBundle.class);
    private final SslReloadTask reloadTask = new SslReloadTask();

    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(final Environment environment) {
        environment.getApplicationContext().addLifeCycleListener(new AbstractLifeCycle.AbstractLifeCycleListener(){

            @Override
            public void lifeCycleStarted(LifeCycle event) {
                ImmutableCollection reloaders = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)SslReloadBundle.this.getReloaders(environment.getApplicationContext()))).addAll((Iterable)SslReloadBundle.this.getReloaders(environment.getAdminContext()))).build();
                LOGGER.info("{} ssl reloaders registered", (Object)reloaders.size());
                SslReloadBundle.this.reloadTask.setReloaders(reloaders);
            }
        });
        environment.admin().addTask(this.reloadTask);
    }

    private Collection<SslReload> getReloaders(MutableServletContextHandler handler) {
        return handler.getServer().getBeans(SslReload.class);
    }
}

