/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import io.dropwizard.servlets.tasks.PostBodyTask;
import io.dropwizard.servlets.tasks.Task;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServlet
extends HttpServlet {
    private static final long serialVersionUID = 7404713218661358124L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServlet.class);
    private final ConcurrentMap<String, Task> tasks;
    private final ConcurrentMap<Task, TaskExecutor> taskExecutors;
    private final MetricRegistry metricRegistry;

    public TaskServlet(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.tasks = new ConcurrentHashMap<String, Task>();
        this.taskExecutors = new ConcurrentHashMap<Task, TaskExecutor>();
    }

    public void add(Task task) {
        this.tasks.put('/' + task.getName(), task);
        TaskExecutor taskExecutor = new TaskExecutor(task);
        try {
            String name;
            Annotation annotation;
            Method executeMethod = task.getClass().getMethod("execute", ImmutableMultimap.class, PrintWriter.class);
            if (executeMethod.isAnnotationPresent(Timed.class)) {
                annotation = executeMethod.getAnnotation(Timed.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, new String[0]);
                taskExecutor = new TimedTask(taskExecutor, this.metricRegistry.timer(name));
            }
            if (executeMethod.isAnnotationPresent(Metered.class)) {
                annotation = executeMethod.getAnnotation(Metered.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, new String[0]);
                taskExecutor = new MeteredTask(taskExecutor, this.metricRegistry.meter(name));
            }
            if (executeMethod.isAnnotationPresent(ExceptionMetered.class)) {
                annotation = executeMethod.getAnnotation(ExceptionMetered.class);
                name = this.chooseName(annotation.name(), annotation.absolute(), task, "exceptions");
                taskExecutor = new ExceptionMeteredTask(taskExecutor, this.metricRegistry.meter(name), annotation.cause());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.taskExecutors.put(task, taskExecutor);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (Strings.isNullOrEmpty(req.getPathInfo())) {
            try (PrintWriter output = resp.getWriter();){
                resp.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
                this.getTasks().stream().map(Task::getName).sorted().forEach(output::println);
            }
        } else if (this.tasks.containsKey(req.getPathInfo())) {
            resp.sendError(405);
        } else {
            resp.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Task task = (Task)this.tasks.get(req.getPathInfo());
        if (task != null) {
            resp.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            try (PrintWriter output = resp.getWriter();){
                TaskExecutor taskExecutor = (TaskExecutor)this.taskExecutors.get(task);
                taskExecutor.executeTask(TaskServlet.getParams(req), this.getBody(req), output);
            }
        } else {
            resp.sendError(404);
        }
    }

    private static ImmutableMultimap<String, String> getParams(HttpServletRequest req) {
        ImmutableMultimap.Builder<String, String> results = ImmutableMultimap.builder();
        Enumeration<String> names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String[] values = req.getParameterValues(name);
            results.putAll(name, values);
        }
        return results.build();
    }

    private String getBody(HttpServletRequest req) throws IOException {
        return CharStreams.toString(new InputStreamReader((InputStream)req.getInputStream(), Charsets.UTF_8));
    }

    public Collection<Task> getTasks() {
        return this.tasks.values();
    }

    private String chooseName(String explicitName, boolean absolute, Task task, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name(task.getClass(), explicitName);
        }
        return MetricRegistry.name(task.getClass(), suffixes);
    }

    private static class ExceptionMeteredTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Meter exceptionMeter;
        private final Class<?> exceptionClass;

        private ExceptionMeteredTask(TaskExecutor underlying, Meter exceptionMeter, Class<? extends Throwable> exceptionClass) {
            super(underlying.task);
            this.underlying = underlying;
            this.exceptionMeter = exceptionMeter;
            this.exceptionClass = exceptionClass;
        }

        private boolean isReallyAssignableFrom(Exception e) {
            return this.exceptionClass.isAssignableFrom(e.getClass()) || e.getCause() != null && this.exceptionClass.isAssignableFrom(e.getCause().getClass());
        }

        @Override
        public void executeTask(ImmutableMultimap<String, String> params, String body, PrintWriter output) throws Exception {
            try {
                this.underlying.executeTask(params, body, output);
            }
            catch (Exception e) {
                if (this.exceptionMeter != null && this.isReallyAssignableFrom(e)) {
                    this.exceptionMeter.mark();
                }
                throw e;
            }
        }
    }

    private static class MeteredTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Meter meter;

        private MeteredTask(TaskExecutor underlying, Meter meter) {
            super(underlying.task);
            this.meter = meter;
            this.underlying = underlying;
        }

        @Override
        public void executeTask(ImmutableMultimap<String, String> params, String body, PrintWriter output) throws Exception {
            this.meter.mark();
            this.underlying.executeTask(params, body, output);
        }
    }

    private static class TimedTask
    extends TaskExecutor {
        private TaskExecutor underlying;
        private final Timer timer;

        private TimedTask(TaskExecutor underlying, Timer timer) {
            super(underlying.task);
            this.underlying = underlying;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeTask(ImmutableMultimap<String, String> params, String body, PrintWriter output) throws Exception {
            Timer.Context context = this.timer.time();
            try {
                this.underlying.executeTask(params, body, output);
            }
            finally {
                context.stop();
            }
        }
    }

    private static class TaskExecutor {
        private final Task task;

        private TaskExecutor(Task task) {
            this.task = task;
        }

        public void executeTask(ImmutableMultimap<String, String> params, String body, PrintWriter output) throws Exception {
            if (this.task instanceof PostBodyTask) {
                PostBodyTask postBodyTask = (PostBodyTask)this.task;
                postBodyTask.execute(params, body, output);
            } else {
                this.task.execute(params, output);
            }
        }
    }
}

