/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging.layout;

import ch.qos.logback.access.pattern.AccessConverter;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Arrays;

public class SafeRequestParameterConverter
extends AccessConverter {
    private String key;

    @Override
    public void start() {
        this.key = this.getFirstOption();
        if (OptionHelper.isEmpty(this.key)) {
            this.addWarn("Missing key for the request parameter");
        } else {
            super.start();
        }
    }

    @Override
    public String convert(IAccessEvent accessEvent) {
        if (!this.isStarted()) {
            return "INACTIVE_REQUEST_PARAM_CONV";
        }
        Object[] paramArray = accessEvent.getRequestParameterMap().get(this.key);
        if (paramArray == null || paramArray.length == 0) {
            return "-";
        }
        if (paramArray.length == 1) {
            return paramArray[0];
        }
        return Arrays.toString(paramArray);
    }
}

