/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.FilterFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.util.function.Consumer;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="console")
public class ConsoleAppenderFactory<E extends DeferredProcessingAware>
extends AbstractAppenderFactory<E> {
    @NotNull
    private ConsoleStream target = ConsoleStream.STDOUT;

    @JsonProperty
    public ConsoleStream getTarget() {
        return this.target;
    }

    @JsonProperty
    public void setTarget(ConsoleStream target) {
        this.target = target;
    }

    @Override
    public Appender<E> build(LoggerContext context, String applicationName, LayoutFactory<E> layoutFactory, LevelFilterFactory<E> levelFilterFactory, AsyncAppenderFactory<E> asyncAppenderFactory) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("console-appender");
        appender.setContext(context);
        appender.setTarget(this.target.get());
        LayoutWrappingEncoder<E> layoutEncoder = new LayoutWrappingEncoder<E>();
        layoutEncoder.setLayout(this.buildLayout(context, layoutFactory));
        appender.setEncoder(layoutEncoder);
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().forEach((Consumer<FilterFactory<FilterFactory>>)((Consumer<FilterFactory>)f -> appender.addFilter(f.build())));
        appender.start();
        return this.wrapAsync(appender, asyncAppenderFactory);
    }

    public static enum ConsoleStream {
        STDOUT("System.out"),
        STDERR("System.err");

        private final String value;

        private ConsoleStream(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }
    }
}

