/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jersey.validation.ConstraintMessage;
import io.dropwizard.jersey.validation.JerseyViolationException;
import io.dropwizard.jersey.validation.ValidationErrorMessage;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.Invocable;

@Provider
public class JerseyViolationExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    @Override
    public Response toResponse(JerseyViolationException exception) {
        Set<ConstraintViolation<?>> violations = exception.getConstraintViolations();
        Invocable invocable = exception.getInvocable();
        ImmutableList<String> errors = FluentIterable.from(exception.getConstraintViolations()).transform(violation -> ConstraintMessage.getMessage(violation, invocable)).toList();
        int status = ConstraintMessage.determineStatus(violations, invocable);
        return Response.status(status).entity(new ValidationErrorMessage(errors)).build();
    }
}

