/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import io.dropwizard.validation.ValidationMethod;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;

public class ConstraintMessage {
    private static final Cache<Pair<Path, ? extends ConstraintDescriptor<?>>, String> MESSAGES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    private ConstraintMessage() {
    }

    public static String getMessage(ConstraintViolation<?> v, Invocable invocable) {
        Pair<Path, ConstraintDescriptor<?>> of = Pair.of(v.getPropertyPath(), v.getConstraintDescriptor());
        String cachedMessage = MESSAGES_CACHE.getIfPresent(of);
        if (cachedMessage == null) {
            String message = ConstraintMessage.calculateMessage(v, invocable);
            MESSAGES_CACHE.put(of, message);
            return message;
        }
        return cachedMessage;
    }

    private static String calculateMessage(ConstraintViolation<?> v, Invocable invocable) {
        Optional<String> returnValueName = ConstraintMessage.getMethodReturnValueName(v);
        if (returnValueName.isPresent()) {
            String name = ConstraintMessage.isValidationMethod(v) ? StringUtils.substringBeforeLast(returnValueName.get(), ".") : returnValueName.get();
            return name + " " + v.getMessage();
        }
        if (ConstraintMessage.isValidationMethod(v)) {
            return v.getMessage();
        }
        Optional<String> entity = ConstraintMessage.isRequestEntity(v, invocable);
        if (entity.isPresent()) {
            String prefix = Strings.isNullOrEmpty(entity.get()) ? "The request body" : entity.get();
            return prefix + " " + v.getMessage();
        }
        Optional<String> memberName = ConstraintMessage.getMemberName(v, invocable);
        if (memberName.isPresent()) {
            return memberName.get() + " " + v.getMessage();
        }
        return v.getPropertyPath() + " " + v.getMessage();
    }

    public static Optional<String> isRequestEntity(ConstraintViolation<?> violation, Invocable invocable) {
        Path.Node parent = Iterables.get(violation.getPropertyPath(), 1, null);
        if (parent == null) {
            return Optional.empty();
        }
        List<Parameter> parameters = invocable.getParameters();
        switch (parent.getKind()) {
            case PARAMETER: {
                Parameter param = parameters.get(parent.as(Path.ParameterNode.class).getParameterIndex());
                if (!param.getSource().equals((Object)Parameter.Source.UNKNOWN)) break;
                return Optional.of(Joiner.on('.').join(Iterables.skip(violation.getPropertyPath(), 2)));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getMemberName(ConstraintViolation<?> violation, Invocable invocable) {
        int size = Iterables.size(violation.getPropertyPath());
        if (size < 2) {
            return Optional.empty();
        }
        Path.Node parent = Iterables.get(violation.getPropertyPath(), size - 2);
        Path.Node member = Iterables.getLast(violation.getPropertyPath());
        switch (parent.getKind()) {
            case PARAMETER: {
                List<Parameter> parameters = invocable.getParameters();
                Parameter param = parameters.get(parent.as(Path.ParameterNode.class).getParameterIndex());
                if (!param.getSource().equals((Object)Parameter.Source.BEAN_PARAM)) break;
                Field field = FieldUtils.getField(param.getRawType(), member.getName(), true);
                return JerseyParameterNameProvider.getParameterNameFromAnnotations(field.getDeclaredAnnotations());
            }
            case METHOD: {
                return Optional.of(member.getName());
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getMethodReturnValueName(ConstraintViolation<?> violation) {
        int returnValueNames = -1;
        StringBuilder result = new StringBuilder("server response");
        for (Path.Node node : violation.getPropertyPath()) {
            if (node.getKind().equals((Object)ElementKind.RETURN_VALUE)) {
                returnValueNames = 0;
                continue;
            }
            if (returnValueNames < 0) continue;
            result.append(returnValueNames++ == 0 ? " " : ".").append(node);
        }
        return returnValueNames >= 0 ? Optional.of(result.toString()) : Optional.empty();
    }

    private static boolean isValidationMethod(ConstraintViolation<?> v) {
        return v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod;
    }

    public static <T extends ConstraintViolation<?>> int determineStatus(Set<T> violations, Invocable invocable) {
        if (violations.size() > 0) {
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            for (Path.Node node : violation.getPropertyPath()) {
                switch (node.getKind()) {
                    case RETURN_VALUE: {
                        return 500;
                    }
                    case PARAMETER: {
                        int index = node.as(Path.ParameterNode.class).getParameterIndex();
                        Parameter parameter = invocable.getParameters().get(index);
                        return parameter.getSource().equals((Object)Parameter.Source.UNKNOWN) ? 422 : 400;
                    }
                }
            }
        }
        return 422;
    }
}

