/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.UnitOfWork;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class UnitOfWorkAspect {
    private final Map<String, SessionFactory> sessionFactories;
    private UnitOfWork unitOfWork;
    private Session session;
    private SessionFactory sessionFactory;

    public UnitOfWorkAspect(Map<String, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public void beforeStart(UnitOfWork unitOfWork) {
        if (unitOfWork == null) {
            return;
        }
        this.unitOfWork = unitOfWork;
        this.sessionFactory = this.sessionFactories.get(unitOfWork.value());
        if (this.sessionFactory == null) {
            if (unitOfWork.value().equals("hibernate") && this.sessionFactories.size() == 1) {
                this.sessionFactory = this.sessionFactories.values().iterator().next();
            } else {
                throw new IllegalArgumentException("Unregistered Hibernate bundle: '" + unitOfWork.value() + "'");
            }
        }
        this.session = this.sessionFactory.openSession();
        try {
            this.configureSession();
            ManagedSessionContext.bind(this.session);
            this.beginTransaction();
        }
        catch (Throwable th) {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind(this.sessionFactory);
            throw th;
        }
    }

    public void afterEnd() {
        if (this.session == null) {
            return;
        }
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            throw e;
        }
    }

    public void onError() {
        if (this.session == null) {
            return;
        }
        try {
            this.rollbackTransaction();
        }
        finally {
            this.onFinish();
        }
    }

    public void onFinish() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
            ManagedSessionContext.unbind(this.sessionFactory);
        }
    }

    protected void configureSession() {
        this.session.setDefaultReadOnly(this.unitOfWork.readOnly());
        this.session.setCacheMode(this.unitOfWork.cacheMode());
        this.session.setHibernateFlushMode(this.unitOfWork.flushMode());
    }

    private void beginTransaction() {
        if (!this.unitOfWork.transactional()) {
            return;
        }
        this.session.beginTransaction();
    }

    private void rollbackTransaction() {
        if (!this.unitOfWork.transactional()) {
            return;
        }
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.rollback();
        }
    }

    private void commitTransaction() {
        if (!this.unitOfWork.transactional()) {
            return;
        }
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.commit();
        }
    }

    protected Session getSession() {
        return this.session;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

