/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.google.common.collect.ImmutableList;
import io.dropwizard.Configuration;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.persistence.Entity;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;

public abstract class ScanningHibernateBundle<T extends Configuration>
extends HibernateBundle<T> {
    protected ScanningHibernateBundle(String pckg) {
        this(pckg, new SessionFactoryFactory());
    }

    protected ScanningHibernateBundle(String pckg, SessionFactoryFactory sessionFactoryFactory) {
        this(new String[]{pckg}, sessionFactoryFactory);
    }

    protected ScanningHibernateBundle(String[] pckgs, SessionFactoryFactory sessionFactoryFactory) {
        super(ScanningHibernateBundle.findEntityClassesFromDirectory(pckgs), sessionFactoryFactory);
    }

    public static ImmutableList<Class<?>> findEntityClassesFromDirectory(String[] pckgs) {
        AnnotationAcceptingListener asl = new AnnotationAcceptingListener(Entity.class);
        PackageNamesScanner scanner = new PackageNamesScanner(pckgs, true);
        while (scanner.hasNext()) {
            String next = scanner.next();
            if (!asl.accept(next)) continue;
            try {
                InputStream in = scanner.open();
                Throwable throwable = null;
                try {
                    asl.process(next, in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("AnnotationAcceptingListener failed to process scanned resource: " + next);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> clazz : asl.getAnnotatedClasses()) {
            builder.add(clazz);
        }
        return builder.build();
    }
}

