/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.util.Generics;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaQuery;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.query.internal.AbstractProducedQuery;

public class AbstractDAO<E> {
    private final SessionFactory sessionFactory;
    private final Class<?> entityClass;

    public AbstractDAO(SessionFactory sessionFactory) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.entityClass = Generics.getTypeParameter(this.getClass());
    }

    protected Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Criteria criteria() {
        return this.currentSession().createCriteria(this.entityClass);
    }

    protected Query namedQuery(String queryName) throws HibernateException {
        return this.currentSession().getNamedQuery(Objects.requireNonNull(queryName));
    }

    protected Query<E> query(String queryString) {
        return this.currentSession().createQuery(Objects.requireNonNull(queryString), (Class)this.getEntityClass());
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected E uniqueResult(CriteriaQuery<E> criteriaQuery) throws HibernateException {
        return (E)AbstractProducedQuery.uniqueElement(this.currentSession().createQuery((CriteriaQuery)Objects.requireNonNull(criteriaQuery)).getResultList());
    }

    protected E uniqueResult(Criteria criteria) throws HibernateException {
        return (E)Objects.requireNonNull(criteria).uniqueResult();
    }

    protected E uniqueResult(Query<E> query) throws HibernateException {
        return Objects.requireNonNull(query).uniqueResult();
    }

    protected List<E> list(Criteria criteria) throws HibernateException {
        return Objects.requireNonNull(criteria).list();
    }

    protected List<E> list(CriteriaQuery<E> criteria) throws HibernateException {
        return this.currentSession().createQuery((CriteriaQuery)Objects.requireNonNull(criteria)).getResultList();
    }

    protected List<E> list(Query<E> query) throws HibernateException {
        return Objects.requireNonNull(query).list();
    }

    protected E get(Serializable id) {
        return (E)this.currentSession().get(this.entityClass, Objects.requireNonNull(id));
    }

    protected E persist(E entity) throws HibernateException {
        this.currentSession().saveOrUpdate(Objects.requireNonNull(entity));
        return entity;
    }

    protected <T> T initialize(T proxy) throws HibernateException {
        if (!Hibernate.isInitialized(proxy)) {
            Hibernate.initialize(proxy);
        }
        return proxy;
    }
}

