/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.basic;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class BasicCredentials {
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicCredentials other = (BasicCredentials)obj;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("username", this.username).add("password", "**********").toString();
    }
}

