/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.dropwizard.auth.Authorizer;
import java.security.Principal;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CachingAuthorizer<P extends Principal>
implements Authorizer<P> {
    private final Authorizer<P> underlying;
    private final Meter cacheMisses;
    private final Timer getsTimer;
    private final Cache<ImmutablePair<P, String>, Boolean> cache;

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CacheBuilderSpec cacheSpec) {
        this(metricRegistry, authorizer, CacheBuilder.from(cacheSpec));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CacheBuilder<Object, Object> builder) {
        this.underlying = authorizer;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authorizer.getClass(), "cache-misses"));
        this.getsTimer = metricRegistry.timer(MetricRegistry.name(authorizer.getClass(), "gets"));
        this.cache = builder.recordStats().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authorize(P principal, String role) {
        Timer.Context context = this.getsTimer.time();
        try {
            ImmutablePair<P, String> cacheKey = ImmutablePair.of(principal, role);
            Boolean isAuthorized = this.cache.getIfPresent(cacheKey);
            if (isAuthorized == null) {
                this.cacheMisses.mark();
                isAuthorized = this.underlying.authorize(principal, role);
                this.cache.put(cacheKey, isAuthorized);
            }
            boolean bl = isAuthorized;
            return bl;
        }
        finally {
            context.stop();
        }
    }

    public void invalidate(P principal, String role) {
        this.cache.invalidate(ImmutablePair.of(principal, role));
    }

    public void invalidate(P principal) {
        Predicate<ImmutablePair> predicate = cacheKey -> ((Principal)cacheKey.getLeft()).equals(principal);
        this.cache.invalidateAll(Sets.filter(this.cache.asMap().keySet(), predicate::test));
    }

    public void invalidateAll(Iterable<P> principals) {
        Predicate<ImmutablePair> predicate = cacheKey -> Iterables.contains(principals, cacheKey.getLeft());
        this.cache.invalidateAll(Sets.filter(this.cache.asMap().keySet(), predicate::test));
    }

    public void invalidateAll(Predicate<? super P> predicate) {
        Predicate<ImmutablePair> nestedPredicate = cacheKey -> predicate.test((Object)cacheKey.getLeft());
        this.cache.invalidateAll(Sets.filter(this.cache.asMap().keySet(), nestedPredicate::test));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

