/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.assets;

import com.google.common.base.Preconditions;
import io.dropwizard.Bundle;
import io.dropwizard.servlets.assets.AssetServlet;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsBundle
implements Bundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetsBundle.class);
    private static final String DEFAULT_ASSETS_NAME = "assets";
    private static final String DEFAULT_INDEX_FILE = "index.htm";
    private static final String DEFAULT_PATH = "/assets";
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;
    private final String assetsName;

    public AssetsBundle() {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String path) {
        this(path, path, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile) {
        this(resourcePath, uriPath, indexFile, DEFAULT_ASSETS_NAME);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName) {
        Preconditions.checkArgument(resourcePath.startsWith("/"), "%s is not an absolute path", (Object)resourcePath);
        Preconditions.checkArgument(!"/".equals(resourcePath), "%s is the classpath root", (Object)resourcePath);
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + '/';
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + '/';
        this.indexFile = indexFile;
        this.assetsName = assetsName;
    }

    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(Environment environment) {
        LOGGER.info("Registering AssetBundle with name: {} for path {}", (Object)this.assetsName, (Object)(this.uriPath + '*'));
        environment.servlets().addServlet(this.assetsName, this.createServlet()).addMapping(this.uriPath + '*');
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    protected AssetServlet createServlet() {
        return new AssetServlet(this.resourcePath, this.uriPath, this.indexFile, StandardCharsets.UTF_8);
    }
}

