/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class InstrumentedQueuedThreadPool
extends QueuedThreadPool {
    private final MetricRegistry metricRegistry;
    private String prefix;

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry) {
        this(registry, 200);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads) {
        this(registry, maxThreads, 8);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
        this(registry, maxThreads, minThreads, 60000);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout) {
        this(registry, maxThreads, minThreads, idleTimeout, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue) {
        this(registry, maxThreads, minThreads, idleTimeout, queue, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="prefix") String prefix) {
        super(maxThreads, minThreads, idleTimeout, queue);
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        String prefix = this.prefix == null ? MetricRegistry.name(QueuedThreadPool.class, this.getName()) : MetricRegistry.name(this.prefix, this.getName());
        this.metricRegistry.register(MetricRegistry.name(prefix, "utilization"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads(), InstrumentedQueuedThreadPool.this.getThreads());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "utilization-max"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads(), InstrumentedQueuedThreadPool.this.getMaxThreads());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "size"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return InstrumentedQueuedThreadPool.this.getThreads();
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "jobs"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return InstrumentedQueuedThreadPool.this.getQueue().size();
            }
        });
    }
}

