/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Timer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class InstrumentedConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final ConnectionFactory connectionFactory;
    private final Timer timer;
    private Method getProtocols;

    public InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer) {
        this.connectionFactory = connectionFactory;
        this.timer = timer;
        this.addBean(connectionFactory);
        try {
            this.getProtocols = connectionFactory.getClass().getMethod("getProtocols", new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            this.getProtocols = null;
        }
    }

    @Override
    public String getProtocol() {
        return this.connectionFactory.getProtocol();
    }

    @Override
    public List<String> getProtocols() {
        try {
            return this.getProtocols != null ? (List)this.getProtocols.invoke((Object)this.connectionFactory, new Object[0]) : Collections.emptyList();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to invoke `connectionFactory#getProtocols`", e);
        }
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Connection connection = this.connectionFactory.newConnection(connector, endPoint);
        connection.addListener(new Connection.Listener(){
            private Timer.Context context;

            @Override
            public void onOpened(Connection connection) {
                this.context = InstrumentedConnectionFactory.this.timer.time();
            }

            @Override
            public void onClosed(Connection connection) {
                this.context.stop();
            }
        });
        return connection;
    }
}

